
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


struct Vehicle {
    char name[20];
    int max_speed;
    int current_speed;
    int direction;
};


void initialize_vehicle(struct Vehicle *v, char name[20], int max_speed, int current_speed, int direction) {
    strcpy(v->name, name);
    v->max_speed = max_speed;
    v->current_speed = current_speed;
    v->direction = direction;
}


void update_speed(struct Vehicle *v, int new_speed) {
    v->current_speed = new_speed;
}


void control_direction(struct Vehicle *v, int new_direction) {
    v->direction = new_direction;
}


void print_status(struct Vehicle *v) {
    printf("Vehicle Name: %s\n", v->name);
    printf("Max Speed: %d\n", v->max_speed);
    printf("Current Speed: %d\n", v->current_speed);
    printf("Direction: %d\n", v->direction);
}

int main() {
    
    struct Vehicle car;
    initialize_vehicle(&car, "Car", 100, 0, 0);

    
    printf("Initial Status:\n");
    print_status(&car);

    
    update_speed(&car, 60);

    
    printf("Updated Status:\n");
    print_status(&car);

    
    control_direction(&car, 1);

    
    printf("Updated Status:\n");
    print_status(&car);

    
    control_direction(&car, -1);

    
    printf("Updated Status:\n");
    print_status(&car);

    
    update_speed(&car, 80);

    
    printf("Updated Status:\n");
    print_status(&car);

    return 0;
}