//Falcon2-11B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_JOBS 5

typedef struct {
    int id;
    int execution_time;
    int priority;
} Job;

void round_robin_scheduling(Job* ol, int an) {
    int i;
    int execution_time = 0;

    for (i = 0; i < an; i++) {
        execution_time += ol[i].execution_time;

        if (i == an - 1) {
            execution_time -= ol[i].execution_time;
        }

        printf("Job %d executed for %d seconds\n", ol[i].id, execution_time);
    }
}

void shortest_job_first_scheduling(Job* ol, int an) {
    int i;
    int execution_time = 0;

    for (i = 0; i < an; i++) {
        execution_time += ol[i].execution_time;

        printf("Job %d executed for %d seconds\n", ol[i].id, execution_time);
    }
}

void first_come_first_serve_scheduling(Job* ol, int an) {
    int i;
    int execution_time = 0;

    for (i = 0; i < an; i++) {
        execution_time += ol[i].execution_time;

        printf("Job %d executed for %d seconds\n", ol[i].id, execution_time);
    }
}

int main() {
    Job ol[MAX_JOBS] = {
        {1, 10, 1},
        {2, 20, 2},
        {3, 30, 3},
        {4, 40, 4},
        {5, 50, 5}
    };

    int an = sizeof(ol) / sizeof(ol[0]);

    round_robin_scheduling(ol, an);
    shortest_job_first_scheduling(ol, an);
    first_come_first_serve_scheduling(ol, an);

    return 0;
}