//Falcon2-11B DATASET v1.0 Category: Poker Game ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_CARDS 52

typedef struct {
    char rank;
    char suit;
} Card;

typedef struct {
    Card cards[5];
    int score;
} Hand;

void display_hand(Hand *hand) {
    for (int i = 0; i < 5; i++) {
        printf("Card %d: %c %c\n", i + 1, hand->cards[i].rank, hand->cards[i].suit);
    }
}

int compare_hand(const Hand *a, const Hand *b) {
    if (a->score == b->score) {
        for (int i = 0; i < 5; i++) {
            if (a->cards[i].rank == b->cards[i].rank) {
                if (a->cards[i].suit < b->cards[i].suit) {
                    return 1;
                } else if (a->cards[i].suit > b->cards[i].suit) {
                    return -1;
                }
            } else {
                return 1;
            }
        }
    } else {
        return 1;
    }
}

int main() {
    Hand hand1, hand2;

    for (int i = 0; i < 5; i++) {
        hand1.cards[i].rank = 'A';
        hand1.cards[i].suit = 'D';
        hand2.cards[i].rank = 'A';
        hand2.cards[i].suit = 'D';
    }

    hand1.score = 20;
    hand2.score = 20;

    printf("Hand 1: ");
    display_hand(&hand1);
    printf("Score: %d\n", hand1.score);
    printf("Hand 2: ");
    display_hand(&hand2);
    printf("Score: %d\n", hand2.score);

    printf("Hand 1 is greater than Hand 2: %d\n", compare_hand(&hand1, &hand2));

    return 0;
}