
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>

int main() {
    
    int socket_descriptor = socket(AF_INET, SOCK_STREAM, 0);
    if (socket_descriptor == -1) {
        perror("Could not create a socket");
        exit(EXIT_FAILURE);
    }

    
    struct sockaddr_in server_address;
    server_address.sin_family = AF_INET;
    server_address.sin_port = htons(8080);
    server_address.sin_addr.s_addr = INADDR_ANY;

    if (bind(socket_descriptor, (struct sockaddr *)&server_address, sizeof(server_address)) == -1) {
        perror("Could not bind the socket");
        exit(EXIT_FAILURE);
    }

    
    if (listen(socket_descriptor, 5) == -1) {
        perror("Could not listen for incoming connections");
        exit(EXIT_FAILURE);
    }

    
    int client_socket_descriptor;
    struct sockaddr_in client_address;
    socklen_t client_address_length = sizeof(client_address);

    client_socket_descriptor = accept(socket_descriptor, (struct sockaddr *)&client_address, &client_address_length);
    if (client_socket_descriptor == -1) {
        perror("Could not accept an incoming connection");
        exit(EXIT_FAILURE);
    }

    
    char *message = "Hello, world!";
    if (send(client_socket_descriptor, message, strlen(message), 0) == -1) {
        perror("Could not send a message to the client");
        exit(EXIT_FAILURE);
    }

    
    char buffer[1024];
    if (recv(client_socket_descriptor, buffer, sizeof(buffer), 0) == -1) {
        perror("Could not receive a message from the client");
        exit(EXIT_FAILURE);
    }

    
    printf("Received a message from the client: %s\n", buffer);

    
    if (close(client_socket_descriptor) == -1) {
        perror("Could not close the client socket descriptor");
        exit(EXIT_FAILURE);
    }

    
    if (close(socket_descriptor) == -1) {
        perror("Could not close the server socket descriptor");
        exit(EXIT_FAILURE);
    }

    return 0;
}