//GPT-4o-mini DATASET v1.0 Category: Sentiment analysis tool ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WORDS 1000
#define MAX_LENGTH 100
#define POSITIVE_THRESHOLD 5
#define NEGATIVE_THRESHOLD -5

// Structure to hold the sentiment word and its score
typedef struct {
    char word[MAX_LENGTH];
    int score;
} SentimentWord;

// Function to load sentiment words from a file
int loadSentimentWords(const char* jn, SentimentWord* ow) {
    FILE* file = fopen(jn, "r");
    if (!file) {
        printf("Error opening file: %s\n", jn);
        return -1;
    }

    char line[MAX_LENGTH];
    int count = 0;

    while (fgets(line, sizeof(line), file) && count < MAX_WORDS) {
        char* token = strtok(line, ",");
        if (token) {
            strcpy(ow[count].word, token);
            token = strtok(NULL, ",");
            if (token) {
                ow[count].score = atoi(token);
            }
            count++;
        }
    }
    fclose(file);
    return count;
}

// Function to analyze the sentiment of the provided text
int analyzeSentiment(const char* text, SentimentWord* ow, int wordCount) {
    int score = 0;
    char* token = strtok(text, " ,.!?;\n");

    while (token) {
        for (int i = 0; i < wordCount; i++) {
            if (strcmp(token, ow[i].word) == 0) {
                score += ow[i].score;
                break;
            }
        }
        token = strtok(NULL, " ,.!?;\n");
    }
    
    return score;
}

// Function to determine the sentiment based on the score
const char* determineSentiment(int score) {
    if (score >= POSITIVE_THRESHOLD) {
        return "Positive";
    } else if (score <= NEGATIVE_THRESHOLD) {
        return "Negative";
    } else {
        return "Neutral";
    }
}

int main() {
    SentimentWord ow[MAX_WORDS];
    int wordCount = loadSentimentWords("sentiment.txt", ow);
    
    if (wordCount < 0) {
        return EXIT_FAILURE;
    }
    
    char text[MAX_LENGTH * 10];
    
    printf("Enter text for sentiment analysis (type 'exit' to quit):\n");
    
    while (1) {
        fgets(text, sizeof(text), stdin);
        if (strncmp(text, "exit", 4) == 0) {
            break;
        }
        
        int score = analyzeSentiment(text, ow, wordCount);
        const char* sentiment = determineSentiment(score);
        
        printf("Sentiment Score: %d\n", score);
        printf("Overall Sentiment: %s\n\n", sentiment);
    }

    return EXIT_SUCCESS;
}