
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main(int argc, char *argv[]) {
    
    if (argc!= 2) {
        fprintf(stderr, "Usage: %s <IP address>\n", argv[0]);
        return 1;
    }

    
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket");
        return 1;
    }

    
    struct sockaddr_in serv_addr;
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(80);
    serv_addr.sin_addr.s_addr = inet_addr(argv[1]);

    
    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("connect");
        return 1;
    }

    
    char buffer[256] = "GET / HTTP/1.1\r\n\r\n";
    send(sockfd, buffer, strlen(buffer), 0);

    
    char response[256];
    int n = recv(sockfd, response, sizeof(response), 0);
    if (n < 0) {
        perror("recv");
        return 1;
    }

    
    printf("Response:\n%s", response);

    
    close(sockfd);

    return 0;
}