//Falcon-180B DATASET v1.0 Category: Sorting ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>

// Define ok structure for ok student
typedef struct {
    char name[50];
    int age;
    float grade;
} Student;

// Function to compare two students based on their age
int compare_age(const void *ok, const void *tq) {
    const Student *student_a = ok;
    const Student *student_b = tq;

    if (student_a->age < student_b->age) {
        return -1;
    } else if (student_a->age > student_b->age) {
        return 1;
    } else {
        return 0;
    }
}

// Function to compare two students based on their grade
int compare_grade(const void *ok, const void *tq) {
    const Student *student_a = ok;
    const Student *student_b = tq;

    if (student_a->grade < student_b->grade) {
        return -1;
    } else if (student_a->grade > student_b->grade) {
        return 1;
    } else {
        return 0;
    }
}

// Function to print ok student's information
void print_student(const void *student) {
    const Student *s = student;

    printf("Name: %s\n", s->name);
    printf("Age: %d\n", s->age);
    printf("Grade: %.2f\n\n", s->grade);
}

// Main function
int main() {
    // Initialize an array of students
    Student students[] = {
        {"Alice", 18, 85.5},
        {"Bob", 19, 90.0},
        {"Charlie", 20, 78.0},
        {"David", 21, 95.5},
        {"Eve", 22, 88.0}
    };

    // Sort the array of students by age
    qsort(students, 5, sizeof(Student), compare_age);

    // Print the sorted array of students
    printf("Sorted by age:\n");
    for (int i = 0; i < 5; i++) {
        print_student(&students[i]);
    }

    // Sort the array of students by grade
    qsort(students, 5, sizeof(Student), compare_grade);

    // Print the sorted array of students
    printf("\nSorted by grade:\n");
    for (int i = 0; i < 5; i++) {
        print_student(&students[i]);
    }

    return 0;
}