
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>


typedef struct Process {
    int pid;         
    int arrivalTime; 
    int burstTime;    
    int priority;     
} Process;


int compareArrivalTime(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p1->arrivalTime - p2->arrivalTime;
}


int comparePriority(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p2->priority - p1->priority;
}


void fcfs(Process *processes, int n) {
    int currentTime = 0;
    int totalWaitingTime = 0;
    int totalTurnaroundTime = 0;

    
    for (int i = 0; i < n; i++) {
        Process *process = &processes[i];

        
        int waitingTime = currentTime - process->arrivalTime;
        totalWaitingTime += waitingTime;

        
        int turnaroundTime = currentTime + process->burstTime - process->arrivalTime;
        totalTurnaroundTime += turnaroundTime;

        
        currentTime += process->burstTime;

        
        printf("Process %d: Waiting time = %d, Turnaround time = %d\n", process->pid, waitingTime, turnaroundTime);
    }

    
    printf("Average waiting time: %.2f\nAverage turnaround time: %.2f\n", (float)totalWaitingTime / n, (float)totalTurnaroundTime / n);
}


void sjf(Process *processes, int n) {
    int currentTime = 0;
    int totalWaitingTime = 0;
    int totalTurnaroundTime = 0;

    
    qsort(processes, n, sizeof(Process), compareArrivalTime);

    
    for (int i = 0; i < n; i++) {
        Process *process = &processes[i];

        
        int waitingTime = currentTime - process->arrivalTime;
        totalWaitingTime += waitingTime;

        
        int turnaroundTime = currentTime + process->burstTime - process->arrivalTime;
        totalTurnaroundTime += turnaroundTime;

        
        currentTime += process->burstTime;

        
        printf("Process %d: Waiting time = %d, Turnaround time = %d\n", process->pid, waitingTime, turnaroundTime);
    }

    
    printf("Average waiting time: %.2f\nAverage turnaround time: %.2f\n", (float)totalWaitingTime / n, (float)totalTurnaroundTime / n);
}


void priority(Process *processes, int n) {
    int currentTime = 0;
    int totalWaitingTime = 0;
    int totalTurnaroundTime = 0;

    
    qsort(processes, n, sizeof(Process), comparePriority);

    
    for (int i = 0; i < n; i++) {
        Process *process = &processes[i];

        
        int waitingTime = currentTime - process->arrivalTime;
        totalWaitingTime += waitingTime;

        
        int turnaroundTime = currentTime + process->burstTime - process->arrivalTime;
        totalTurnaroundTime += turnaroundTime;

        
        currentTime += process->burstTime;

        
        printf("Process %d: Waiting time = %d, Turnaround time = %d\n", process->pid, waitingTime, turnaroundTime);
    }

    
    printf("Average waiting time: %.2f\nAverage turnaround time: %.2f\n", (float)totalWaitingTime / n, (float)totalTurnaroundTime / n);
}

int main() {
    
    Process processes[] = {
        {1, 0, 5, 1},
        {2, 2, 3, 3},
        {3, 3, 4, 2},
        {4, 4, 6, 4},
        {5, 5, 2, 1}
    };
    int n = sizeof(processes) / sizeof(processes[0]);

    
    printf("FCFS Scheduling Algorithm:\n");
    fcfs(processes, n);
    printf("\n");

    
    printf("SJF Scheduling Algorithm:\n");
    sjf(processes, n);
    printf("\n");

    
    printf("Priority Scheduling Algorithm:\n");
    priority(processes, n);
    printf("\n");

    return 0;
}