//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Process structure
typedef struct Process {
    int pid;         // Process ID
    int arrivalTime; // Arrival time
    int burstTime;    // Burst time
    int priority;     // Priority
} Process;

// Compare function for sorting processes by arrival time
int compareArrivalTime(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p1->arrivalTime - p2->arrivalTime;
}

// Compare function for sorting processes by priority
int comparePriority(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p2->priority - p1->priority;
}

// Function to simulate FCFS scheduling algorithm
void fcfs(Process *processes, int n) {
    int currentTime = 0;
    int totalWaitingTime = 0;
    int totalTurnaroundTime = 0;

    // Iterate over the processes
    for (int i = 0; i < n; i++) {
        Process *process = &processes[i];

        // Calculate waiting time
        int waitingTime = currentTime - process->arrivalTime;
        totalWaitingTime += waitingTime;

        // Calculate turnaround time
        int turnaroundTime = currentTime + process->burstTime - process->arrivalTime;
        totalTurnaroundTime += turnaroundTime;

        // Update current time
        currentTime += process->burstTime;

        // Display process details
        printf("Process %d: Waiting time = %d, Turnaround time = %d\n", process->pid, waitingTime, turnaroundTime);
    }

    // Display average waiting time and average turnaround time
    printf("Average waiting time: %.2f\nAverage turnaround time: %.2f\n", (float)totalWaitingTime / n, (float)totalTurnaroundTime / n);
}

// Function to simulate SJF scheduling algorithm
void sjf(Process *processes, int n) {
    int currentTime = 0;
    int totalWaitingTime = 0;
    int totalTurnaroundTime = 0;

    // Sort processes by arrival time
    qsort(processes, n, sizeof(Process), compareArrivalTime);

    // Iterate over the processes
    for (int i = 0; i < n; i++) {
        Process *process = &processes[i];

        // Calculate waiting time
        int waitingTime = currentTime - process->arrivalTime;
        totalWaitingTime += waitingTime;

        // Calculate turnaround time
        int turnaroundTime = currentTime + process->burstTime - process->arrivalTime;
        totalTurnaroundTime += turnaroundTime;

        // Update current time
        currentTime += process->burstTime;

        // Display process details
        printf("Process %d: Waiting time = %d, Turnaround time = %d\n", process->pid, waitingTime, turnaroundTime);
    }

    // Display average waiting time and average turnaround time
    printf("Average waiting time: %.2f\nAverage turnaround time: %.2f\n", (float)totalWaitingTime / n, (float)totalTurnaroundTime / n);
}

// Function to simulate priority scheduling algorithm
void priority(Process *processes, int n) {
    int currentTime = 0;
    int totalWaitingTime = 0;
    int totalTurnaroundTime = 0;

    // Sort processes by priority
    qsort(processes, n, sizeof(Process), comparePriority);

    // Iterate over the processes
    for (int i = 0; i < n; i++) {
        Process *process = &processes[i];

        // Calculate waiting time
        int waitingTime = currentTime - process->arrivalTime;
        totalWaitingTime += waitingTime;

        // Calculate turnaround time
        int turnaroundTime = currentTime + process->burstTime - process->arrivalTime;
        totalTurnaroundTime += turnaroundTime;

        // Update current time
        currentTime += process->burstTime;

        // Display process details
        printf("Process %d: Waiting time = %d, Turnaround time = %d\n", process->pid, waitingTime, turnaroundTime);
    }

    // Display average waiting time and average turnaround time
    printf("Average waiting time: %.2f\nAverage turnaround time: %.2f\n", (float)totalWaitingTime / n, (float)totalTurnaroundTime / n);
}

int main() {
    // Initialize processes
    Process processes[] = {
        {1, 0, 5, 1},
        {2, 2, 3, 3},
        {3, 3, 4, 2},
        {4, 4, 6, 4},
        {5, 5, 2, 1}
    };
    int n = sizeof(processes) / sizeof(processes[0]);

    // Simulate FCFS scheduling algorithm
    printf("FCFS Scheduling Algorithm:\n");
    fcfs(processes, n);
    printf("\n");

    // Simulate SJF scheduling algorithm
    printf("SJF Scheduling Algorithm:\n");
    sjf(processes, n);
    printf("\n");

    // Simulate priority scheduling algorithm
    printf("Priority Scheduling Algorithm:\n");
    priority(processes, n);
    printf("\n");

    return 0;
}