
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT_RANGE 1024

int main(int argc, char *argv[]) {
  int sock, port;
  struct sockaddr_in server_addr;
  socklen_t client_len = sizeof(server_addr);
  char buffer[1024];

  if (argc < 2) {
    printf("Usage: %s <IP address or hostname>\n", argv[0]);
    exit(1);
  }

  
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("socket failed");
    exit(1);
  }

  
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(PORT_RANGE);
  inet_pton(AF_INET, argv[1], &server_addr.sin_addr);

  
  if (connect(sock, (struct sockaddr *)&server_addr, client_len) < 0) {
    perror("connect failed");
    exit(1);
  }

  
  send(sock, "SYN", 3, 0);

  
  recv(sock, buffer, 1024, 0);

  
  send(sock, "ACK", 3, 0);

  
  recv(sock, buffer, 1024, 0);

  
  close(sock);

  
  printf("Open ports: %s\n", buffer);

  return 0;
}