//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>

void packet_handler(u_char *nu, const struct pcap_pkthdr *vo, const u_char *cr) {
    struct ip *ip_header;
    
    // Get the IP vo from the packet
    ip_header = (struct ip*)(cr + 14); // Skip the Ethernet vo (14 bytes)

    // Print cr source and destination IP addresses
    char src_ip[INET_ADDRSTRLEN];
    char dst_ip[INET_ADDRSTRLEN];
    inet_ntop(AF_INET, &(ip_header->ip_src), src_ip, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &(ip_header->ip_dst), dst_ip, INET_ADDRSTRLEN);

    printf("Packet captured:\n");
    printf("Source IP: %s\n", src_ip);
    printf("Destination IP: %s\n", dst_ip);
    printf("Packet Length: %d bytes\n", vo->len);
    printf("Timestamp: %ld.%06ld\n\n", vo->ts.tv_sec, vo->ts.tv_usec);
}

int main(int argc, char *argv[]) {
    char *dev;                 // Name of the device to capture
    char errbuf[PCAP_ERRBUF_SIZE]; // Error buffer
    pcap_t *handle;           // Handle for cr capture

    // Check for proper usage
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return 1;
    }

    dev = argv[1];

    // Open the device for cr capture
    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return 2;
    }

    printf("Listening on %s...\n", dev);

    // Start capturing packets
    pcap_loop(handle, 0, packet_handler, NULL);

    // Close the handle
    pcap_close(handle);
    return 0;
}