//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather conditions
typedef enum {
    SUNNY,
    CLOUDY,
    RAINY,
    STORMY
} weather_condition;

// Define the weather simulation parameters
#define NUM_DAYS 30
#define MIN_TEMP 10
#define MAX_TEMP 30
#define MIN_RAIN 0
#define MAX_RAIN 10
#define MIN_WIND 0
#define MAX_WIND 10

// Generate a random weather condition
weather_condition generate_weather() {
    int random_number = rand() % 4;
    switch (random_number) {
        case 0:
            return SUNNY;
        case 1:
            return CLOUDY;
        case 2:
            return RAINY;
        case 3:
            return STORMY;
    }
}

// Generate a random temperature
int generate_temperature() {
    return rand() % (MAX_TEMP - MIN_TEMP + 1) + MIN_TEMP;
}

// Generate a random amount of rain
int generate_rain() {
    return rand() % (MAX_RAIN - MIN_RAIN + 1) + MIN_RAIN;
}

// Generate a random amount of wind
int generate_wind() {
    return rand() % (MAX_WIND - MIN_WIND + 1) + MIN_WIND;
}

// Print the weather forecast for a given day
void print_weather_forecast(int day, weather_condition condition, int temperature, int rain, int wind) {
    printf("Day %d: ", day);
    switch (condition) {
        case SUNNY:
            printf("Sunny");
            break;
        case CLOUDY:
            printf("Cloudy");
            break;
        case RAINY:
            printf("Rainy");
            break;
        case STORMY:
            printf("Stormy");
            break;
    }
    printf(", %d degrees, %dmm of rain, %dkm/h wind\n", temperature, rain, wind);
}

// Generate the weather forecast for the next 30 days
void generate_weather_forecast() {
    srand(time(NULL));
    for (int i = 0; i < NUM_DAYS; i++) {
        weather_condition condition = generate_weather();
        int temperature = generate_temperature();
        int rain = generate_rain();
        int wind = generate_wind();
        print_weather_forecast(i + 1, condition, temperature, rain, wind);
    }
}

int main() {
    // Generate and print the weather forecast
    generate_weather_forecast();

    return 0;
}