//MISTRAL-7B DATASET v1.0 Category: File handling ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#define FILE_NAME "example.txt"
#define DATA_TO_WRITE "Hello World!"
#define APPEND_DATA "Appended Data!"
#define BUFFER_SIZE 100

int main() {
    int file_fd;
    char buffer[BUFFER_SIZE];

    // Create a file with the given name
    file_fd = open(FILE_NAME, O_CREAT | O_WRONLY | O_TRUNC, 0644);
    if (file_fd < 0) {
        perror("Error creating file");
        exit(EXIT_FAILURE);
    }

    // Write some data to the file
    if (write(file_fd, DATA_TO_WRITE, strlen(DATA_TO_WRITE)) < 0) {
        perror("Error writing to file");
        close(file_fd);
        exit(EXIT_FAILURE);
    }

    // Read the data from the file
    if (read(file_fd, buffer, BUFFER_SIZE) < 0) {
        perror("Error reading from file");
        close(file_fd);
        exit(EXIT_FAILURE);
    }

    printf("Data read from file: %s\n", buffer);

    // Append some data to the file
    if (lseek(file_fd, 0, SEEK_END) < 0) {
        perror("Error moving file pointer to end");
        close(file_fd);
        exit(EXIT_FAILURE);
    }

    if (write(file_fd, APPEND_DATA, strlen(APPEND_DATA)) < 0) {
        perror("Error writing to file");
        close(file_fd);
        exit(EXIT_FAILURE);
    }

    // Delete the file
    if (unlink(FILE_NAME) < 0) {
        perror("Error deleting file");
        close(file_fd);
        exit(EXIT_FAILURE);
    }

    printf("File deleted successfully!\n");

    close(file_fd);
    return EXIT_SUCCESS;
}