//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: complete
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name[], int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Item limit exceeded.\n");
}

void displayItems() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s - %d, $%.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }
}

void calculateTotal(int totalItems) {
    float totalAmount = 0;
    for (int i = 0; i < totalItems; i++) {
        totalAmount += items[i].quantity * items[i].price;
    }

    printf("Total items: %d\n", totalItems);
    printf("Total amount: $%.2f\n", totalAmount);
}

int main() {
    addItem("Coffee", 5, 2.50);
    addItem("Tea", 3, 1.75);
    addItem("Juice", 2, 1.25);

    displayItems();

    calculateTotal(3);

    return 0;
}