

#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>


#define PORT 8080

int main() {
  
  int server_socket = socket(AF_INET, SOCK_STREAM, 0);
  if (server_socket == -1) {
    perror("Socket creation failed");
    return 1;
  }

  
  struct sockaddr_in server_addr;
  memset(&server_addr, 0, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(PORT);
  server_addr.sin_addr.s_addr = htonl(INADDR_ANY);

  
  if (bind(server_socket, (struct sockaddr*)&server_addr, sizeof(server_addr)) == -1) {
    perror("Bind failed");
    return 1;
  }

  
  if (listen(server_socket, 5) == -1) {
    perror("Listen failed");
    return 1;
  }

  
  int client_socket = accept(server_socket, NULL, NULL);
  if (client_socket == -1) {
    perror("Accept failed");
    return 1;
  }

  
  char buffer[1024];
  int n = read(client_socket, buffer, sizeof(buffer));
  if (n == -1) {
    perror("Read failed");
    return 1;
  }

  
  n = write(client_socket, buffer, n);
  if (n == -1) {
    perror("Write failed");
    return 1;
  }

  
  close(client_socket);

  
  close(server_socket);

  return 0;
}