//GEMINI-pro DATASET v1.0 Category: Expense Tracker ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ENTRIES 100

typedef struct {
  char description[50];
  float amount;
} Expense;

Expense expenses[MAX_ENTRIES];
int num_expenses = 0;

void add_expense(char *description, float amount) {
  if (num_expenses < MAX_ENTRIES) {
    strcpy(expenses[num_expenses].description, description);
    expenses[num_expenses].amount = amount;
    num_expenses++;
  } else {
    printf("Error: Maximum number of expenses reached.\n");
  }
}

void print_expenses() {
  for (int i = 0; i < num_expenses; i++) {
    printf("%s %.2f\n", expenses[i].description, expenses[i].amount);
  }
}

float calculate_total() {
  float total = 0;
  for (int i = 0; i < num_expenses; i++) {
    total += expenses[i].amount;
  }
  return total;
}

int main() {
  // Add some sample expenses
  add_expense("Groceries", 100.00);
  add_expense("Rent", 1200.00);
  add_expense("Utilities", 150.00);
  add_expense("Transportation", 200.00);
  add_expense("Entertainment", 100.00);

  // Print the expenses
  printf("Your expenses are:\n");
  print_expenses();

  // Calculate the total
  float total = calculate_total();
  printf("Your total expenses are: %.2f\n", total);

  return 0;
}