//GEMINI-pro DATASET v1.0 Category: Website Uptime Monitor ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <curl/curl.h>

// Custom data structure to hold website uptime information
typedef struct website_uptime {
    char *url;              // Website URL
    int status_code;        // HTTP status code of the last request
    time_t last_checked;    // Time of the last uptime check
    int is_up;              // Flag indicating if the website is currently up
} website_uptime;

// Function to check the uptime of a website
int check_website_uptime(website_uptime *website) {
    CURL *curl;
    CURLcode res;

    // Initialize the CURL library
    curl = curl_easy_init();
    if (!curl) {
        fprintf(stderr, "Error initializing CURL\n");
        return EXIT_FAILURE;
    }

    // Set the URL to check
    curl_easy_setopt(curl, CURLOPT_URL, website->url);

    // Set the timeout for the request
    curl_easy_setopt(curl, CURLOPT_TIMEOUT, 10);

    // Perform the HTTP request
    res = curl_easy_perform(curl);

    // Get the HTTP status code of the response
    curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &website->status_code);

    // Update the last checked time
    website->last_checked = time(NULL);

    // Check if the website is up
    website->is_up = (website->status_code == 200);

    // Cleanup the CURL library
    curl_easy_cleanup(curl);

    return EXIT_SUCCESS;
}

// Function to print the uptime information for a website
void print_website_uptime(website_uptime *website) {
    printf("URL: %s\n", website->url);
    printf("Status code: %d\n", website->status_code);
    printf("Last checked: %s", ctime(&website->last_checked));
    printf("Is up: %s\n", website->is_up ? "Yes" : "No");
}

// Main function
int main() {
    // Create a list of websites to check
    website_uptime websites[] = {
        { .url = "https://google.com" },
        { .url = "https://amazon.com" },
        { .url = "https://microsoft.com" },
        { .url = "https://apple.com" },
        { .url = "https://facebook.com" }
    };

    // Check the uptime of each website
    for (int i = 0; i < sizeof(websites) / sizeof(website_uptime); i++) {
        if (check_website_uptime(&websites[i]) != EXIT_SUCCESS) {
            fprintf(stderr, "Error checking uptime of %s\n", websites[i].url);
        }
    }

    // Print the uptime information for each website
    for (int i = 0; i < sizeof(websites) / sizeof(website_uptime); i++) {
        print_website_uptime(&websites[i]);
        printf("\n");
    }

    return EXIT_SUCCESS;
}