//GPT-4o-mini DATASET v1.0 Category: Browser Plugin ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Mock structure to represent a webpage
typedef struct {
    char title[100];
    char url[100];
} WebPage;

// Plugin to log the title of the webpage
typedef struct {
    void (*onPageLoad)(WebPage *page);
} BrowserPlugin;

void logPageTitle(WebPage *page) {
    printf("Surprise! The page title is: %s\n", page->title);
}

void simulateBrowserAction(BrowserPlugin *plugin, WebPage *page) {
    printf("Simulating loading the page with URL: %s\n", page->url);
    // Simulate a page load by calling the plugin's callback
    if (plugin->onPageLoad) {
        plugin->onPageLoad(page);
    }
}

int main() {
    // Initialize a webpage
    WebPage myPage;
    strcpy(myPage.title, "Welcome to the Mysterious C Plugin!");
    strcpy(myPage.url, "https://www.samplewebsite.com");

    // Create a browser plugin and set the onPageLoad function
    BrowserPlugin myPlugin;
    myPlugin.onPageLoad = logPageTitle;

    // Simulate loading the webpage
    simulateBrowserAction(&myPlugin, &myPage);

    // Create more pages to surprise the user
    WebPage pages[2];
    strcpy(pages[0].title, "A Journey through code!");
    strcpy(pages[0].url, "https://www.codejourney.com");

    strcpy(pages[1].title, "Surprising Secrets of C!");
    strcpy(pages[1].url, "https://www.secretsinC.com");

    // Simulate loading multiple pages
    for (int i = 0; i < 2; i++) {
        simulateBrowserAction(&myPlugin, &pages[i]);
    }

    // Dynamic memory example - creating a page
    WebPage *dynamicPage = (WebPage *)malloc(sizeof(WebPage));
    if (dynamicPage == NULL) {
        fprintf(stderr, "Memory allocation failed!\n");
        return 1;
    }

    strcpy(dynamicPage->title, "Dynamically Created Surprise!");
    strcpy(dynamicPage->url, "https://www.dynamicpage.com");

    // Simulate loading the dynamically created page
    simulateBrowserAction(&myPlugin, dynamicPage);

    // Free the allocated memory
    free(dynamicPage);

    // Return success
    printf("All pages have been logged! What a surprising journey!\n");
    return 0;
}