//Falcon-180B DATASET v1.0 Category: Intrusion detection system ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_EVENTS 1000
#define MAX_EVENT_NAME_LEN 20
#define MAX_EVENT_VALUE_LEN 100

typedef struct {
    char name[MAX_EVENT_NAME_LEN];
    char value[MAX_EVENT_VALUE_LEN];
} Event;

int event_count = 0;
Event events[MAX_EVENTS];

void add_event(char* name, char* value) {
    if (event_count >= MAX_EVENTS) {
        printf("Error: Maximum number of events reached.\n");
        return;
    }

    strcpy(events[event_count].name, name);
    strcpy(events[event_count].value, value);
    event_count++;
}

int compare_events(const void* a, const void* b) {
    const Event* event_a = (const Event*)a;
    const Event* event_b = (const Event*)b;

    return strcmp(event_a->name, event_b->name);
}

void print_events() {
    qsort(events, event_count, sizeof(Event), compare_events);

    for (int i = 0; i < event_count; i++) {
        printf("%s: %s\n", events[i].name, events[i].value);
    }
}

int main() {
    add_event("Login", "Success");
    add_event("Login", "Failed");
    add_event("Login", "Locked");
    add_event("Login", "Expired");
    add_event("Login", "Invalid");

    print_events();

    return 0;
}