//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <time.h>

// Define the number of stocks to track
#define NUM_STOCKS 5

// Define the structure for each stock
typedef struct {
    char symbol[10];
    double price;
    int volume;
} stock_t;

// Define the array of stocks
stock_t stocks[NUM_STOCKS];

// Define the function to initialize the stocks
void init_stocks() {
    strcpy(stocks[0].symbol, "AAPL");
    stocks[0].price = 150.0;
    stocks[0].volume = 10000;

    strcpy(stocks[1].symbol, "GOOG");
    stocks[1].price = 1200.0;
    stocks[1].volume = 5000;

    strcpy(stocks[2].symbol, "MSFT");
    stocks[2].price = 300.0;
    stocks[2].volume = 2000;

    strcpy(stocks[3].symbol, "FB");
    stocks[3].price = 200.0;
    stocks[3].volume = 1500;

    strcpy(stocks[4].symbol, "AMZN");
    stocks[4].price = 3000.0;
    stocks[4].volume = 1000;
}

// Define the function to print the stocks
void print_stocks() {
    printf("Symbol\tPrice\tVolume\n");
    for(int i=0; i<NUM_STOCKS; i++) {
        printf("%s\t%.2f\t%d\n", stocks[i].symbol, stocks[i].price, stocks[i].volume);
    }
}

// Define the function to update the stocks
void update_stocks() {
    srand(time(0));
    for(int i=0; i<NUM_STOCKS; i++) {
        stocks[i].price += rand() % 20 - 10;
        stocks[i].volume += rand() % 1000;
    }
}

// Define the main function
int main() {
    init_stocks();
    printf("Initial Stocks:\n");
    print_stocks();

    update_stocks();
    printf("\nUpdated Stocks:\n");
    print_stocks();

    return 0;
}