//LLAMA2-13B DATASET v1.0 Category: System administration ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/types.h>

#define MAX_CMD_LEN 1024
#define MAX_ARGS 64

// Structure to store command and its arguments
typedef struct {
    char *cmd;
    char *args[MAX_ARGS];
} command_t;

// Function to execute a command and its arguments
int execute_command(command_t *cmd) {
    int status;
    pid_t pid;

    // Create a new process
    pid = fork();
    if (pid == 0) {
        // Child process
        execvp(cmd->cmd, cmd->args);
        perror("execvp");
        exit(1);
    } else if (pid > 0) {
        // Parent process
        wait(&status);
    }

    return status;
}

int main() {
    // Create a command and its arguments
    command_t cmd = {
        .cmd = "/bin/ls",
        .args = {
            "-l",
            "-t",
            "/etc/passwd"
        }
    };

    // Execute the command
    int status = execute_command(&cmd);

    // Print the command and its arguments
    printf("Command: %s %s\n", cmd.cmd, cmd.args[0]);

    return 0;
}