//MISTRAL-7B DATASET v1.0 Category: Secure Password Generator ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define LENGTH 16
#define PHRASE_LENGTH 20
#define CHAR_SET_SIZE 10

char char_set[CHAR_SET_SIZE] = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '!'};

void generate_password(char *password) {
    int i, j;
    for (i = 0; i < LENGTH; i++) {
        int index = rand() % CHAR_SET_SIZE;
        password[i] = char_set[index];
    }
    password[LENGTH] = '\0';
}

void generate_phrase(char *phrase) {
    int i;
    char animals[5][PHRASE_LENGTH] = {
        "The curious cat jumps over the moon",
        "The quick brown fox jumps over the lazy dog",
        "The sly fox jumps over the sleeping hare",
        "The nimble monkey climbs up the tall tree",
        "The wise owl hoots at the bright moon"};

    for (i = 0; i < PHRASE_LENGTH; i++) {
        phrase[i] = animals[rand() % 5][i];
    }
    phrase[PHRASE_LENGTH] = '\0';
}

int main() {
    srand(time(NULL));

    char password[LENGTH + 1], phrase[PHRASE_LENGTH + 1];

    generate_password(password);
    generate_phrase(phrase);

    printf("\033[1;31m%s\n", "PASSWORD:");
    printf("\033[1;36m%s\n", password);

    printf("\033[1;31m%s\n", "PHRASE:");
    printf("\033[1;33m%s\033[1;31m ", phrase);
    printf("\033[1;35m%s\n", "Press any key to exit...");

    getchar();
    return 0;
}