//Falcon-180B DATASET v1.0 Category: Fractal Generation ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_ITERATIONS 1000
#define MAX_WIDTH 800
#define MAX_HEIGHT 800
#define MAX_DEPTH 50
#define MIN_DEPTH 1

int fractal_generator(int x1, int y1, int x2, int y2, int depth) {
    int x = x1, y = y1;
    int iterations = 0;

    while (iterations < MAX_ITERATIONS && depth >= MIN_DEPTH && depth <= MAX_DEPTH) {
        int delta_x = (x2 - x1) / (MAX_WIDTH - 1);
        int delta_y = (y2 - y1) / (MAX_HEIGHT - 1);

        if (depth == 1) {
            if (x >= 0 && x < MAX_WIDTH && y >= 0 && y < MAX_HEIGHT) {
                printf("%d ", depth);
            }
        } else {
            int temp_x = x + delta_x * depth;
            int temp_y = y + delta_y * depth;

            if (temp_x >= 0 && temp_x < MAX_WIDTH && temp_y >= 0 && temp_y < MAX_HEIGHT) {
                printf("%d ", depth);
            }

            if (depth % 2 == 0) {
                x -= delta_x;
                y -= delta_y;
            } else {
                x += delta_x;
                y += delta_y;
            }
        }

        iterations++;
        depth++;
    }

    return 0;
}

int main() {
    int x1 = -400, y1 = -300;
    int x2 = 400, y2 = 300;

    fractal_generator(x1, y1, x2, y2, 1);

    return 0;
}