//GEMINI-pro DATASET v1.0 Category: Password management ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

// Define the maximum length of a password
#define MAX_PASS_LEN 32

// Define the structure of a password entry
typedef struct {
    char username[32];
    char password[MAX_PASS_LEN];
} password_entry;

// The password database is stored in an array of password entries
password_entry password_db[MAX_PASS_LEN];

// The current number of password entries in the database
int num_passwords = 0;

// Function to add a new password entry to the database
void add_password(char *username, char *password) {
    // Check if the database is full
    assert(num_passwords < MAX_PASS_LEN);

    // Copy the username and password into the new entry
    strcpy(password_db[num_passwords].username, username);
    strcpy(password_db[num_passwords].password, password);

    // Increment the number of password entries
    num_passwords++;
}

// Function to find a password entry in the database
password_entry *find_password(char *username) {
    // Iterate over the password entries
    for (int i = 0; i < num_passwords; i++) {
        // Compare the username to the username in the current entry
        if (strcmp(password_db[i].username, username) == 0) {
            // Return the current entry if the usernames match
            return &password_db[i];
        }
    }

    // Return NULL if the username was not found
    return NULL;
}

// Function to delete a password entry from the database
void delete_password(char *username) {
    // Find the password entry in the database
    password_entry *entry = find_password(username);

    // If the password entry was not found, return
    if (entry == NULL) {
        return;
    }

    // Shift the remaining password entries down to fill the gap
    for (int i = entry - password_db; i < num_passwords - 1; i++) {
        password_db[i] = password_db[i + 1];
    }

    // Decrement the number of password entries
    num_passwords--;
}

// Function to print the password database
void print_passwords() {
    // Iterate over the password entries
    for (int i = 0; i < num_passwords; i++) {
        // Print the username and password for each entry
        printf("%s: %s\n", password_db[i].username, password_db[i].password);
    }
}

int main() {
    // Add some password entries to the database
    add_password("admin", "password1");
    add_password("user1", "password2");
    add_password("user2", "password3");

    // Print the password database
    print_passwords();

    // Find a password entry in the database
    password_entry *entry = find_password("user1");

    // If the password entry was found, print the username and password
    if (entry != NULL) {
        printf("Found password entry for user1: %s\n", entry->password);
    } else {
        printf("Password entry for user1 not found.\n");
    }

    // Delete a password entry from the database
    delete_password("user2");

    // Print the password database
    print_passwords();

    return 0;
}