//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_LINKS 1000

typedef struct {
    char name[20];
    int id;
} Node;

typedef struct {
    int src_id;
    int dest_id;
    int weight;
} Link;

Node nodes[MAX_NODES];
Link links[MAX_LINKS];

int num_nodes = 0;
int num_links = 0;

void add_node(char* name, int id) {
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = id;
    num_nodes++;
}

void add_link(int src_id, int dest_id, int weight) {
    links[num_links].src_id = src_id;
    links[num_links].dest_id = dest_id;
    links[num_links].weight = weight;
    num_links++;
}

void print_nodes() {
    printf("Nodes:\n");
    for(int i=0; i<num_nodes; i++) {
        printf("%d. %s\n", nodes[i].id, nodes[i].name);
    }
}

void print_links() {
    printf("\nLinks:\n");
    for(int i=0; i<num_links; i++) {
        printf("%d -> %d (%d)\n", links[i].src_id, links[i].dest_id, links[i].weight);
    }
}

int main() {
    add_node("Node A", 1);
    add_node("Node B", 2);
    add_node("Node C", 3);
    add_node("Node D", 4);

    add_link(1, 2, 10);
    add_link(2, 3, 20);
    add_link(3, 4, 30);

    print_nodes();
    print_links();

    return 0;
}