//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WAREHOUSE_SIZE 100
#define MAX_PRODUCT_SIZE 50

typedef struct {
    char name[MAX_PRODUCT_SIZE];
    int quantity;
    float price;
} product;

typedef struct {
    product products[MAX_WAREHOUSE_SIZE];
    int size;
} warehouse;

void initialize_warehouse(warehouse *w) {
    w->size = 0;
}

int add_product(product *p, char *name, int quantity, float price) {
    strcpy(p->name, name);
    p->quantity = quantity;
    p->price = price;
    return 1;
}

int add_product_to_warehouse(warehouse *w, product *p) {
    if (w->size >= MAX_WAREHOUSE_SIZE) {
        printf("Warehouse is full!\n");
        return 0;
    }
    w->products[w->size++] = *p;
    return 1;
}

int remove_product_from_warehouse(warehouse *w, product *p) {
    int i;
    for (i = 0; i < w->size; i++) {
        if (strcmp(w->products[i].name, p->name) == 0) {
            w->size--;
            return 1;
        }
    }
    printf("Product not found in warehouse!\n");
    return 0;
}

void display_warehouse(warehouse *w) {
    int i;
    printf("Warehouse contents:\n");
    for (i = 0; i < w->size; i++) {
        printf("%s - %d units - $%.2f each\n", w->products[i].name, w->products[i].quantity, w->products[i].price);
    }
}

int main() {
    warehouse my_warehouse;
    initialize_warehouse(&my_warehouse);

    product my_product;
    add_product(&my_product, "Widget", 100, 10.99);
    add_product_to_warehouse(&my_warehouse, &my_product);

    display_warehouse(&my_warehouse);

    product another_product;
    add_product(&another_product, "Gizmo", 50, 19.99);
    add_product_to_warehouse(&my_warehouse, &another_product);

    display_warehouse(&my_warehouse);

    remove_product_from_warehouse(&my_warehouse, &my_product);

    display_warehouse(&my_warehouse);

    return 0;
}