//GEMINI-pro DATASET v1.0 Category: Cafe Billing System ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_NAME_LEN 50

typedef struct {
    char name[MAX_NAME_LEN];
    int quantity;
    float price;
} Item;

typedef struct {
    Item items[MAX_ITEMS];
    int numItems;
    float total;
} Order;

void add_item(Order *order, Item item) {
    if (order->numItems < MAX_ITEMS) {
        order->items[order->numItems++] = item;
    } else {
        printf("Error: Maximum number of items reached.\n");
    }
}

void print_order(Order order) {
    printf("Order:\n");
    for (int i = 0; i < order.numItems; i++) {
        printf("  %s\t%d\t%.2f\n", order.items[i].name, order.items[i].quantity, order.items[i].price);
    }
    printf("Total: %.2f\n", order.total);
}

int main() {
    Order order;
    order.numItems = 0;
    order.total = 0.0;

    // Add some items to the order
    Item item1 = {"Coffee", 2, 2.50};
    add_item(&order, item1);
    Item item2 = {"Tea", 1, 1.50};
    add_item(&order, item2);
    Item item3 = {"Muffin", 3, 3.00};
    add_item(&order, item3);

    // Print the order
    print_order(order);

    return 0;
}