//Gemma-7B DATASET v1.0 Category: Simulation of the Solar System ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.14159

#define NUM_PLANETS 8

typedef struct Planet {
  char name[20];
  double mass, radius, distance, orbital_speed, rotation_speed;
  int color;
} Planet;

Planet planets[NUM_PLANETS] = {
  {"Sun", 998000, 696000, 0, 0, 0, 0},
  {"Mercury", 3.3e-3, 2.4e6, 59, 0, 0, 1},
  {"Venus", 4.8e-3, 6.0e6, 67, 0, 0, 2},
  {"Earth", 5.9e-3, 6.37e6, 93, 0, 0, 3},
  {"Mars", 0.6e-3, 6.78e6, 248, 0, 0, 4},
  {"Jupiter", 5.9e-3, 699000, 59, 0, 0, 5},
  {"Saturn", 5.9e-3, 600000, 67, 0, 0, 6},
  {"Uranus", 5.9e-3, 250000, 93, 0, 0, 7}
};

void draw_planets() {
  for (int i = 0; i < NUM_PLANETS; i++) {
    switch (planets[i].color) {
      case 0:
        printf("  %s (yellow)\n", planets[i].name);
        break;
      case 1:
        printf("  %s (red)\n", planets[i].name);
        break;
      case 2:
        printf("  %s (orange)\n", planets[i].name);
        break;
      case 3:
        printf("  %s (green)\n", planets[i].name);
        break;
      case 4:
        printf("  %s (brown)\n", planets[i].name);
        break;
      case 5:
        printf("  %s (grey)\n", planets[i].name);
        break;
      case 6:
        printf("  %s (blue)\n", planets[i].name);
        break;
      case 7:
        printf("  %s (purple)\n", planets[i].name);
        break;
    }
  }
}

int main() {
  draw_planets();

  return 0;
}