//GEMINI-pro DATASET v1.0 Category: Data structures visualization ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Sherlock's pipe data structure
typedef struct {
    char *brand;
    int length;
    int weight;
} Pipe;

// Watson's magnifying glass data structure
typedef struct {
    int magnification;
    float focal_length;
    char *lens_type;
} MagnifyingGlass;

// Moriarty's criminal network data structure
typedef struct {
    char *name;
    int age;
    char *occupation;
    struct CriminalNetworkNode *associates;
} CriminalNetworkNode;

// Function to print Sherlock's pipe details
void printPipe(Pipe *pipe) {
    printf("Pipe: %s\n", pipe->brand);
    printf("Length: %d\n", pipe->length);
    printf("Weight: %d\n", pipe->weight);
}

// Function to print Watson's magnifying glass details
void printMagnifyingGlass(MagnifyingGlass *glass) {
    printf("Magnification: %d\n", glass->magnification);
    printf("Focal length: %.2f\n", glass->focal_length);
    printf("Lens type: %s\n", glass->lens_type);
}

// Function to print Moriarty's criminal network
void printCriminalNetwork(CriminalNetworkNode *node) {
    if (node == NULL) {
        printf("No associates found.\n");
        return;
    }

    printf("Name: %s\n", node->name);
    printf("Age: %d\n", node->age);
    printf("Occupation: %s\n", node->occupation);

    printf("Associates:\n");
    CriminalNetworkNode *curr = node->associates;
    while (curr != NULL) {
        printf("  - %s\n", curr->name);
        curr = curr->associates;
    }
}

int main() {
    // Creating and initializing Sherlock's pipe
    Pipe pipe = {"Peterson", 12, 42};

    // Creating and initializing Watson's magnifying glass
    MagnifyingGlass glass = {10, 1.5, "Convex"};

    // Creating and initializing Moriarty's criminal network
    CriminalNetworkNode Moriarty = {"Moriarty", 45, "Criminal mastermind", NULL};
    CriminalNetworkNode IreneAdler = {"Irene Adler", 30, "Adventuress", NULL};
    CriminalNetworkNode ColonelSebastianMoran = {"Colonel Sebastian Moran", 50, "Hitman", NULL};

    // Adding associates to Moriarty's criminal network
    Moriarty.associates = &IreneAdler;
    IreneAdler.associates = &ColonelSebastianMoran;

    // Printing Sherlock's pipe details
    printf("Sherlock's Pipe:\n");
    printPipe(&pipe);

    // Printing Watson's magnifying glass details
    printf("\nWatson's Magnifying Glass:\n");
    printMagnifyingGlass(&glass);

    // Printing Moriarty's criminal network
    printf("\nMoriarty's Criminal Network:\n");
    printCriminalNetwork(&Moriarty);

    return 0;
}