//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_NAME_LEN 50
#define MAX_QUANTITY 1000

typedef struct {
    char name[MAX_NAME_LEN];
    int quantity;
} Product;

Product products[MAX_PRODUCTS];
int num_products = 0;

void add_product(char* name, int quantity) {
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: Maximum number of products reached.\n");
        return;
    }
    strcpy(products[num_products].name, name);
    products[num_products].quantity = quantity;
    num_products++;
}

void remove_product(int index) {
    if (index < 0 || index >= num_products) {
        printf("Error: Invalid product index.\n");
        return;
    }
    num_products--;
    for (int i = index; i < num_products; i++) {
        strcpy(products[i].name, products[i+1].name);
        products[i].quantity = products[i+1].quantity;
    }
}

void print_products() {
    printf("Product Inventory:\n");
    for (int i = 0; i < num_products; i++) {
        printf("%d. %s - %d units\n", i+1, products[i].name, products[i].quantity);
    }
}

void search_product(char* name) {
    int index = -1;
    for (int i = 0; i < num_products; i++) {
        if (strcmp(products[i].name, name) == 0) {
            index = i;
            break;
        }
    }
    if (index == -1) {
        printf("Product not found.\n");
    } else {
        printf("Product found at index %d.\n", index+1);
    }
}

int main() {
    add_product("Apples", 50);
    add_product("Oranges", 25);
    add_product("Bananas", 75);
    print_products();
    search_product("Bananas");
    remove_product(1);
    print_products();
    return 0;
}