//LLAMA2-13B DATASET v1.0 Category: Phone Book ; Style: retro
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define PHONE_BOOK_SIZE 100

typedef struct {
    char name[20];
    char number[20];
} phone_entry_t;

phone_entry_t phone_book[PHONE_BOOK_SIZE];
int num_entries = 0;

void add_entry(char *name, char *number) {
    if (num_entries >= PHONE_BOOK_SIZE) {
        printf("Phone book is full! Please delete some entries first.\n");
        return;
    }

    strcpy(phone_book[num_entries].name, name);
    strcpy(phone_book[num_entries].number, number);
    num_entries++;
}

void delete_entry(int index) {
    if (index < 0 || index >= num_entries) {
        printf("Invalid entry index!\n");
        return;
    }

    memset(phone_book[index].name, 0, 20);
    memset(phone_book[index].number, 0, 20);
    num_entries--;
}

void print_entries() {
    printf("Phone book entries:\n");
    for (int i = 0; i < num_entries; i++) {
        printf("%d: %s %s\n", i, phone_book[i].name, phone_book[i].number);
    }
}

int main() {
    srand(time(NULL));

    // Add some entries to the phone book
    add_entry("John Doe", "555-1234");
    add_entry("Jane Doe", "555-5678");
    add_entry("Bob Smith", "555-9012");

    // Delete some entries from the phone book
    delete_entry(1);
    delete_entry(2);

    // Print the remaining entries
    print_entries();

    return 0;
}