//GEMINI-pro DATASET v1.0 Category: Smart home light control ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of lights
#define MAX_LIGHTS 10

// Define the states of a light
#define LIGHT_OFF 0
#define LIGHT_ON 1

// Define the commands that can be sent to the lights
#define CMD_ON "ON"
#define CMD_OFF "OFF"
#define CMD_TOGGLE "TOGGLE"

// Define the structure of a light
typedef struct light {
    int state;
    char *name;
} light;

// Create an array of lights
light lights[MAX_LIGHTS];

// Initialize the lights
void init_lights() {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        lights[i].state = LIGHT_OFF;
        lights[i].name = NULL;
    }
}

// Set the state of a light
void set_light_state(int light_index, int state) {
    if (light_index >= 0 && light_index < MAX_LIGHTS) {
        lights[light_index].state = state;
    }
}

// Get the state of a light
int get_light_state(int light_index) {
    if (light_index >= 0 && light_index < MAX_LIGHTS) {
        return lights[light_index].state;
    }
    return -1;
}

// Toggle the state of a light
void toggle_light(int light_index) {
    if (light_index >= 0 && light_index < MAX_LIGHTS) {
        lights[light_index].state = !lights[light_index].state;
    }
}

// Set the name of a light
void set_light_name(int light_index, char *name) {
    if (light_index >= 0 && light_index < MAX_LIGHTS) {
        lights[light_index].name = name;
    }
}

// Get the name of a light
char *get_light_name(int light_index) {
    if (light_index >= 0 && light_index < MAX_LIGHTS) {
        return lights[light_index].name;
    }
    return NULL;
}

// Print the state of all lights
void print_lights() {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        printf("Light %d: %s\n", i, lights[i].state == LIGHT_OFF ? "OFF" : "ON");
    }
}

// Main function
int main() {
    // Initialize the lights
    init_lights();

    // Set the name of light 0 to "Living Room Light"
    set_light_name(0, "Living Room Light");

    // Turn on light 0
    set_light_state(0, LIGHT_ON);

    // Toggle light 1
    toggle_light(1);

    // Print the state of all lights
    print_lights();

    return 0;
}