//Gemma-7B DATASET v1.0 Category: Network Ping Test ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

#define SERVER_PORT 5000
#define BUFFER_SIZE 1024

int main()
{
    int sockfd, n, err, server_fd;
    char buffer[BUFFER_SIZE];
    struct sockaddr_in server_addr;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_DGRAM, htons(SERVER_PORT));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Connect to the server
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SERVER_PORT);
    server_addr.sin_addr.s_addr = inet_addr("192.168.1.1");
    err = connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr));
    if (err < 0)
    {
        perror("Error connecting to server");
        exit(1);
    }

    // Send a ping message
    strcpy(buffer, "PING");
    n = send(sockfd, buffer, strlen(buffer), 0);
    if (n < 0)
    {
        perror("Error sending message");
        exit(1);
    }

    // Receive the ping response
    n = recv(sockfd, buffer, BUFFER_SIZE, 0);
    if (n < 0)
    {
        perror("Error receiving message");
        exit(1);
    }

    // Print the ping response
    printf("Received: %s\n", buffer);

    // Close the socket
    close(sockfd);

    return 0;
}