//MISTRAL-7B DATASET v1.0 Category: Bitwise operations ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>

typedef unsigned int uint;

#define BIT(x) (1 << (x))

void print_binary(uint num) {
    for (int i = 31; i >= 0; i--) {
        printf("%d", (num >> i) & 1);
    }
    printf("\n");
}

void set_bit(uint* num, int index) {
    *num |= BIT(index);
}

void clear_bit(uint* num, int index) {
    *num &= ~BIT(index);
}

void toggle_bit(uint* num, int index) {
    *num ^= BIT(index);
}

void check_bit(uint num, int index) {
    if (num & BIT(index)) {
        printf("Bit %d is set.\n", index);
    } else {
        printf("Bit %d is not set.\n", index);
    }
}

void swap_bits(uint* num, int index1, int index2) {
    uint mask1 = BIT(index1);
    uint mask2 = BIT(index2);
    uint temp = (*num & mask1) | (*num & mask2);
    *num = (*num & ~mask1 & ~mask2) | (temp & ~mask1 | mask2);
}

void print_bits(uint num, int num_bits) {
    uint mask = ~((1 << num_bits) - 1);
    for (int i = 0; i < num_bits; i++) {
        if (num & mask) {
            printf("1");
        } else {
            printf("0");
        }
        num <<= 1;
        mask >>= 1;
    }
    printf("\n");
}

int main() {
    uint num = 0;

    printf("Binary representation of number before operations:\n");
    print_binary(num);

    set_bit(&num, 3);
    printf("Binary representation of number after setting bit 3:\n");
    print_binary(num);

    clear_bit(&num, 3);
    printf("Binary representation of number after clearing bit 3:\n");
    print_binary(num);

    toggle_bit(&num, 3);
    printf("Binary representation of number after toggling bit 3:\n");
    print_binary(num);

    check_bit(num, 3);

    swap_bits(&num, 2, 3);
    printf("Binary representation of number after swapping bits 2 and 3:\n");
    print_binary(num);

    print_bits(num, 5);

    return 0;
}