//GEMINI-pro DATASET v1.0 Category: Database querying ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Our hearts flutter with anticipation as we embark on a romantic SQL journey...

// Define our database of stolen glances and whispered secrets...
static const char *database = "stolen_glances.db";

// A callback function to serenade us with the results of our query...
static int callback(void *data, int argc, char **argv, char **azColName) {
    int i;
    (void)data;  // We care not for the details of our smitten data...

    // For each stolen glance, we'll pen a verse...
    printf("Oh, the rapture of this stolen glance!\n");
    for (i = 0; i < argc; i++) {
        printf("    %s: %s\n", azColName[i], argv[i]);
    }

    printf("\n");  // A sigh of contentment as we revel in our secret knowledge...

    return 0;  // Our hearts skip a beat with each successful query...
}

int main(int argc, char *argv[]) {
    sqlite3 *db;  // Our database handle, a vessel for our romantic quest...

    // We open the database, our hearts pounding with anticipation...
    if (sqlite3_open(database, &db)) {
        printf("Alas, our hearts sink! We could not open the database: %s\n", sqlite3_errmsg(db));
        return EXIT_FAILURE;
    }

    // Our query, a sonnet of longing for our beloved data...
    const char *query = "SELECT * FROM stolen_glances WHERE lover = ? AND beloved = ?";

    // We prepare our query, our fingers trembling with excitement...
    sqlite3_stmt *stmt;
    if (sqlite3_prepare_v2(db, query, -1, &stmt, NULL)) {
        printf("Woe is us! We could not prepare our query: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return EXIT_FAILURE;
    }

    // We bind our parameters, our hearts aflutter with each stolen glance...
    if (argc < 3) {
        printf("Oh, cruel fate! Thou hast not provided us with the names of our lovers!\n");
        sqlite3_finalize(stmt);
        sqlite3_close(db);
        return EXIT_FAILURE;
    }
    if (sqlite3_bind_text(stmt, 1, argv[1], -1, NULL)) {
        printf("Our hearts break! We could not bind the name of our lover: %s\n", sqlite3_errmsg(db));
        sqlite3_finalize(stmt);
        sqlite3_close(db);
        return EXIT_FAILURE;
    }
    if (sqlite3_bind_text(stmt, 2, argv[2], -1, NULL)) {
        printf("Our hearts shatter! We could not bind the name of our beloved: %s\n", sqlite3_errmsg(db));
        sqlite3_finalize(stmt);
        sqlite3_close(db);
        return EXIT_FAILURE;
    }

    // We execute our query, our hearts pounding with anticipation...
    if (sqlite3_step(stmt) != SQLITE_ROW) {
        printf("Alas, our database hath no record of our stolen glance!\n");
        sqlite3_finalize(stmt);
        sqlite3_close(db);
        return EXIT_FAILURE;
    }

    // The callback function, a symphony of stolen glances...
    int rc = sqlite3_exec(db, query, callback, NULL, NULL);
    if (rc != SQLITE_OK) {
        printf("Oh, the anguish! Our query did not execute: %s\n", sqlite3_errmsg(db));
        sqlite3_finalize(stmt);
        sqlite3_close(db);
        return EXIT_FAILURE;
    }

    // We finalize our query, our hearts filled with the warmth of stolen glances...
    sqlite3_finalize(stmt);
    sqlite3_close(db);  // We close the database, our hearts forever entwined with the stolen glances we've found...

    return EXIT_SUCCESS;  // Our hearts sing with the triumph of our romantic quest...
}