//Gemma-7B DATASET v1.0 Category: RAM usage monitor ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

#define MAX_Players 4

typedef struct Player {
    char name[20];
    int ram_usage;
    int online;
} Player;

Player players[MAX_Players];

void update_player_ram_usage(char *name, int ram_usage) {
    for (int i = 0; i < MAX_Players; i++) {
        if (strcmp(players[i].name, name) == 0) {
            players[i].ram_usage = ram_usage;
        }
    }
}

int main() {
    // Initialize players
    for (int i = 0; i < MAX_Players; i++) {
        players[i].online = 0;
    }

    // Loop until a player disconnects
    while (1) {
        // Get the player's name and RAM usage
        char name[20];
        int ram_usage;
        scanf("Enter your name: ", name);
        scanf("Enter your RAM usage: ", &ram_usage);

        // Update the player's RAM usage
        update_player_ram_usage(name, ram_usage);

        // Check if the player has disconnected
        if (players[0].online == 0) {
            break;
        }
    }

    // Print the final RAM usage for each player
    for (int i = 0; i < MAX_Players; i++) {
        if (players[i].online) {
            printf("%s's RAM usage: %d KB\n", players[i].name, players[i].ram_usage);
        }
    }

    return 0;
}