//GEMINI-pro DATASET v1.0 Category: Modern Encryption ; Style: innovative
// An innovative C Modern Encryption example program.

// We'll use the AES-256 cipher in CBC mode with a randomly generated IV.
#include <openssl/aes.h>
#include <openssl/rand.h>
#include <stdio.h>
#include <stdlib.h>

// Our encryption function.
int encrypt(const unsigned char *plaintext, int plaintext_len,
            unsigned char *ciphertext, unsigned char *iv) {
    // Generate a random IV.
    if (RAND_bytes(iv, AES_BLOCK_SIZE) != 1) {
        return -1;
    }

    // Create an AES-256 CBC context.
    AES_KEY key;
    if (AES_set_encrypt_key(plaintext, 256, &key) != 0) {
        return -1;
    }

    // Encrypt the plaintext.
    AES_cbc_encrypt(plaintext, ciphertext, plaintext_len, &key, iv, AES_ENCRYPT);

    // Return the ciphertext length.
    return plaintext_len;
}

// Our decryption function.
int decrypt(const unsigned char *ciphertext, int ciphertext_len,
            unsigned char *plaintext, unsigned char *iv) {
    // Create an AES-256 CBC context.
    AES_KEY key;
    if (AES_set_decrypt_key(ciphertext, 256, &key) != 0) {
        return -1;
    }

    // Decrypt the ciphertext.
    AES_cbc_encrypt(ciphertext, plaintext, ciphertext_len, &key, iv, AES_DECRYPT);

    // Return the plaintext length.
    return ciphertext_len;
}

// Our main function.
int main() {
    // Our plaintext.
    const char *plaintext = "Hello, world!";

    // Our ciphertext.
    unsigned char ciphertext[strlen(plaintext) + AES_BLOCK_SIZE];

    // Our IV.
    unsigned char iv[AES_BLOCK_SIZE];

    // Encrypt the plaintext.
    int ciphertext_len = encrypt(plaintext, strlen(plaintext), ciphertext, iv);
    if (ciphertext_len == -1) {
        perror("Error encrypting plaintext");
        return EXIT_FAILURE;
    }

    // Print the ciphertext.
    printf("Ciphertext: ");
    for (int i = 0; i < ciphertext_len; i++) {
        printf("%02x", ciphertext[i]);
    }
    printf("\n");

    // Decrypt the ciphertext.
    unsigned char decryptedtext[ciphertext_len];
    int decryptedtext_len = decrypt(ciphertext, ciphertext_len, decryptedtext, iv);
    if (decryptedtext_len == -1) {
        perror("Error decrypting ciphertext");
        return EXIT_FAILURE;
    }

    // Print the decryptedtext.
    printf("Decryptedtext: %s\n", decryptedtext);

    return EXIT_SUCCESS;
}