//Falcon-180B DATASET v1.0 Category: Firewall ; Style: shape shifting
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdbool.h>

#define MAX_RULES 100
#define MAX_RULE_LENGTH 100
#define MAX_IP_LENGTH 16
#define ALLOW 1
#define DENY 0

typedef struct rule_t {
    char ip[MAX_IP_LENGTH];
    int allow;
} rule_t;

rule_t rules[MAX_RULES];
int num_rules = 0;

void add_rule(char* ip, int allow) {
    if (num_rules >= MAX_RULES) {
        printf("Error: Maximum number of rules exceeded.\n");
        return;
    }

    strncpy(rules[num_rules].ip, ip, MAX_IP_LENGTH);
    rules[num_rules].allow = allow;
    num_rules++;
}

int is_allowed(char* ip) {
    for (int i = 0; i < num_rules; i++) {
        if (strcmp(rules[i].ip, ip) == 0 && rules[i].allow == ALLOW) {
            return true;
        }
    }

    return false;
}

int main() {
    add_rule("192.168.1.1", ALLOW);
    add_rule("192.168.1.2", DENY);

    char* ip = "192.168.1.1";
    if (is_allowed(ip)) {
        printf("Access allowed for IP: %s\n", ip);
    } else {
        printf("Access denied for IP: %s\n", ip);
    }

    return 0;
}