//MISTRAL-7B DATASET v1.0 Category: Pattern printing ; Style: Romeo and Juliet
#include <stdio.h>
#include <string.h>

#define MAX_NAME_LENGTH 21
#define MAX_MESSAGE_LENGTH 101

struct Person {
    char name[MAX_NAME_LENGTH];
    int isAlive;
};

struct Message {
    struct Person sender;
    struct Person receiver;
    char message[MAX_MESSAGE_LENGTH];
};

void printGreeting(const char *name) {
    printf("\n***** %s's Love Letter *****\n", name);
}

void printGoodbye(const char *name) {
    printf("\n***** Farewell, %s *****\n", name);
}

void printMessage(struct Message msg) {
    printGreeting(msg.sender.name);
    printf("\nFrom: %s\nTo: %s\nMessage: %s\n", msg.sender.name, msg.receiver.name, msg.message);
    printGoodbye(msg.sender.name);
}

void main() {
    struct Person romeo = {"Romeo", 1};
    struct Person juliet = {"Juliet", 1};

    struct Message messages[3] = {
        {"Benvolio", "Romeo", "Dear Romeo, I hear a rumor of a feud between Montagues and Capulets. Let us meet secretly tonight at the chapel."},
        {"Friar Laurence", "Romeo", "Romeo, tonight is the night. Come to the chapel, Juliet will be there."},
        {"Juliet", "Romeo", "My dearest Romeo, our love will never fade. Let us meet tonight at the tomb."}
    };

    for (int i = 0; i < 3; i++) {
        if (strcmp(messages[i].sender.name, "Romeo") == 0) {
            romeo.isAlive = 0;
            printMessage(messages[i]);
            break;
        }
        printMessage(messages[i]);
    }

    if (romeo.isAlive) {
        printf("\nRomeo is still alive.\n");
    } else {
        printf("\nRomeo has met his tragic end.\n");
    }
}