//GEMINI-pro DATASET v1.0 Category: RAM usage monitor ; Style: light-weight
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

// Assuming RAM starts at 0x20000000 and ends at 0x40000000
#define RAM_START 0x20000000
#define RAM_END 0x40000000
#define RAM_SIZE (RAM_END - RAM_START)

// Define a custom data structure to store RAM usage information
typedef struct {
    uint32_t start;
    uint32_t end;
    uint32_t size;
    uint32_t used;
    uint32_t free;
} ram_usage_t;

// Function to initialize the RAM usage structure
void init_ram_usage(ram_usage_t *ram_usage) {
    ram_usage->start = RAM_START;
    ram_usage->end = RAM_END;
    ram_usage->size = RAM_SIZE;
    ram_usage->used = 0;
    ram_usage->free = RAM_SIZE;
}

// Function to allocate memory from RAM
void *ram_alloc(ram_usage_t *ram_usage, uint32_t size) {
    // Check if there is enough free memory
    if (size > ram_usage->free) {
        return NULL; // Not enough memory to allocate
    }

    // Allocate memory from the free memory pool
    void *ptr = (void *)ram_usage->start + ram_usage->used;
    ram_usage->used += size;
    ram_usage->free -= size;

    return ptr;
}

// Function to free memory allocated from RAM
void ram_free(ram_usage_t *ram_usage, void *ptr, uint32_t size) {
    // Check if the pointer is within the allocated memory range
    if (ptr < (void *)ram_usage->start || ptr > (void *)(ram_usage->start + ram_usage->used)) {
        return; // Invalid pointer
    }

    // Free the memory and update the used/free memory pool
    ram_usage->used -= size;
    ram_usage->free += size;
}

// Function to print the RAM usage information
void print_ram_usage(ram_usage_t *ram_usage) {
    printf("RAM Usage:\n");
    printf("    Start Address: 0x%08x\n", ram_usage->start);
    printf("    End Address: 0x%08x\n", ram_usage->end);
    printf("    Total Size: %u bytes\n", ram_usage->size);
    printf("    Used Memory: %u bytes\n", ram_usage->used);
    printf("    Free Memory: %u bytes\n", ram_usage->free);
}

// Main function to test the RAM usage monitor
int main() {
    // Initialize the RAM usage structure
    ram_usage_t ram_usage;
    init_ram_usage(&ram_usage);

    // Allocate and free memory multiple times to show the dynamic RAM usage
    for (int i = 0; i < 10; i++) {
        // Allocate memory in blocks of 1KB
        void *ptr = ram_alloc(&ram_usage, 1024);
        if (ptr != NULL) {
            // Use the allocated memory for some purpose...
        } else {
            // Not enough memory to allocate
            printf("Failed to allocate memory\n");
        }

        // Free the allocated memory
        ram_free(&ram_usage, ptr, 1024);
    }

    // Print the RAM usage information
    print_ram_usage(&ram_usage);

    return 0;
}