//Falcon2-11B DATASET v1.0 Category: Queue Implementation ; Style: safe
#include <stdio.h>

#define MAX_SIZE 10

typedef struct queue {
    int front;
    int rear;
    int data[MAX_SIZE];
} queue;

void push(queue *q, int value) {
    if (q->rear == MAX_SIZE - 1) {
        printf("Queue is full.\n");
        return;
    }
    q->rear++;
    q->data[q->rear] = value;
}

int pop(queue *q) {
    if (q->front == q->rear) {
        printf("Queue is empty.\n");
        return -1;
    }
    int value = q->data[q->front];
    q->front++;
    return value;
}

int peek(queue *q) {
    if (q->front == q->rear) {
        printf("Queue is empty.\n");
        return -1;
    }
    return q->data[q->front];
}

int main() {
    queue myQueue;
    myQueue.front = 0;
    myQueue.rear = -1;

    push(&myQueue, 1);
    push(&myQueue, 2);
    push(&myQueue, 3);

    int value = pop(&myQueue);
    printf("Popped value: %d\n", value);

    value = peek(&myQueue);
    printf("Peeked value: %d\n", value);

    return 0;
}