//GPT-4o-mini DATASET v1.0 Category: Greedy Algorithms ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#define MAX_ACTIVITIES 100

typedef struct {
    int start;
    int end;
    int index;
} Activity;

// Global array to store activities
Activity activities[MAX_ACTIVITIES];
int activityCount;

// To keep track of selected activities
int selectedCount = 0;

// Mutex for thread safety
pthread_mutex_t mutex;

void* selectActivities(void* arg) {
    int lastActivityIndex = -1;

    // Sort activities based on their finish times
    for (int i = 0; i < activityCount; i++) {
        if (lastActivityIndex == -1 || activities[i].start >= activities[lastActivityIndex].end) {
            pthread_mutex_lock(&mutex);
            // Select the activity
            lastActivityIndex = i;
            selectedCount++;
            printf("Selected Activity %d: Start = %d, End = %d\n",
                   activities[i].index, activities[i].start, activities[i].end);
            pthread_mutex_unlock(&mutex);
        }
    }
    return NULL;
}

int compare(const void* a, const void* b) {
    Activity* activityA = (Activity*)a;
    Activity* activityB = (Activity*)b;
    return activityA->end - activityB->end;
}

int main() {
    pthread_mutex_init(&mutex, NULL);
    
    // Example activities (You can modify this as desired)
    activities[0] = (Activity){0, 6, 0};
    activities[1] = (Activity){3, 4, 1};
    activities[2] = (Activity){1, 2, 2};
    activities[3] = (Activity){5, 7, 3};
    activities[4] = (Activity){8, 9, 4};
    activities[5] = (Activity){5, 9, 5};

    activityCount = 6;

    // Sort the activities based on their end times
    qsort(activities, activityCount, sizeof(Activity), compare);

    // Create a thread to select activities
    pthread_t thread;

    if (pthread_create(&thread, NULL, selectActivities, NULL) != 0) {
        perror("Failed to create thread");
        exit(EXIT_FAILURE);
    }

    // Wait for the selection thread to finish
    pthread_join(thread, NULL);

    printf("Total number of selected activities: %d\n", selectedCount);
    
    pthread_mutex_destroy(&mutex);

    return 0;
}