//LLAMA2-13B DATASET v1.0 Category: System administration ; Style: active
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#define MAX_CMD_LENGTH 1024
#define MAX_ARGS 64

int main(void) {
    char *cmd;
    char *args[MAX_ARGS];
    int status;

    // Example 1: Running a command and capturing its output
    cmd = "ls -l /";
    printf("Running command: %s\n", cmd);
    if (execv(cmd, args) == -1) {
        perror("execv failed");
        return 1;
    }
    printf("Output: %s\n", stdout);

    // Example 2: Running a command with arguments
    cmd = "grep -r 'Linux' /";
    printf("Running command: %s\n", cmd);
    if (execv(cmd, args) == -1) {
        perror("execv failed");
        return 1;
    }
    printf("Output: %s\n", stdout);

    // Example 3: Running a command in background and capturing its PID
    cmd = "tail -f /var/log/syslog";
    printf("Running command: %s\n", cmd);
    if (fork() == 0) { // child process
        execv(cmd, args);
    } else { // parent process
        wait(&status);
        printf("PID: %d\n", status);
    }

    // Example 4: Running a command with redirection
    cmd = "cat /etc/os-release > /tmp/os-release";
    printf("Running command: %s\n", cmd);
    if (execv(cmd, args) == -1) {
        perror("execv failed");
        return 1;
    }

    return 0;
}