//Falcon-180B DATASET v1.0 Category: System boot optimizer ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#define MAX_PROCESSES 10
#define MAX_CPU_TIME_IN_MS 200

typedef struct {
    int pid;
    int cpu_time;
} process_t;

void print_processes(process_t processes[], int num_processes) {
    for (int i = 0; i < num_processes; i++) {
        printf("Process %d: CPU time %d ms\n", processes[i].pid, processes[i].cpu_time);
    }
}

void run_process(int pid, int cpu_time) {
    sleep(cpu_time / 10); // Simulate CPU usage
    printf("Process %d completed\n", pid);
}

int main() {
    srand(time(NULL));

    process_t processes[MAX_PROCESSES];
    int num_processes = 0;

    // Create some processes
    for (int i = 0; i < 5; i++) {
        int cpu_time = rand() % MAX_CPU_TIME_IN_MS + 1;
        if (num_processes < MAX_PROCESSES) {
            processes[num_processes].pid = i + 1;
            processes[num_processes].cpu_time = cpu_time;
            num_processes++;
        }
    }

    // Run the processes
    for (int i = 0; i < num_processes; i++) {
        int pid = processes[i].pid;
        int cpu_time = processes[i].cpu_time;
        printf("Starting process %d (CPU time %d ms)\n", pid, cpu_time);
        run_process(pid, cpu_time);
    }

    // Print the results
    printf("\nProcesses completed:\n");
    print_processes(processes, num_processes);

    return 0;
}