//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_STOCKS 100
#define MAX_NAME_LEN 100
#define MAX_TICKER_LEN 10
#define MAX_PRICE_LEN 10

typedef struct {
    char name[MAX_NAME_LEN];
    char ticker[MAX_TICKER_LEN];
    char price[MAX_PRICE_LEN];
} Stock;

int numStocks = 0;
Stock stocks[MAX_STOCKS];

void addStock(char* name, char* ticker, char* price) {
    if (numStocks >= MAX_STOCKS) {
        printf("Error: Maximum number of stocks reached.\n");
        return;
    }
    
    strcpy(stocks[numStocks].name, name);
    strcpy(stocks[numStocks].ticker, ticker);
    strcpy(stocks[numStocks].price, price);
    
    numStocks++;
}

void removeStock(int index) {
    if (index < 0 || index >= numStocks) {
        printf("Error: Invalid stock index.\n");
        return;
    }
    
    numStocks--;
    for (int i = index; i < numStocks; i++) {
        stocks[i] = stocks[i+1];
    }
}

void updateStock(int index, char* name, char* ticker, char* price) {
    if (index < 0 || index >= numStocks) {
        printf("Error: Invalid stock index.\n");
        return;
    }
    
    strcpy(stocks[index].name, name);
    strcpy(stocks[index].ticker, ticker);
    strcpy(stocks[index].price, price);
}

void displayStocks() {
    printf("Name\tTicker\tPrice\n");
    for (int i = 0; i < numStocks; i++) {
        printf("%s\t%s\t%s\n", stocks[i].name, stocks[i].ticker, stocks[i].price);
    }
}

int main() {
    addStock("Apple Inc.", "AAPL", "138.23");
    addStock("Microsoft Corporation", "MSFT", "246.28");
    addStock("Alphabet Inc.", "GOOGL", "1717.49");
    
    displayStocks();
    
    removeStock(1);
    
    displayStocks();
    
    updateStock(0, "Apple Inc.", "AAPL", "150.00");
    
    displayStocks();
    
    return 0;
}