//GEMINI-pro DATASET v1.0 Category: File system simulation ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_SIZE 1024

typedef struct {
    char name[32];
    int size;
    char data[MAX_SIZE];
} file_t;

typedef struct {
    file_t files[MAX_FILES];
    int num_files;
} filesystem_t;

filesystem_t fs;

void init_filesystem() {
    fs.num_files = 0;
}

int create_file(char *name, int size) {
    if (fs.num_files >= MAX_FILES) {
        return -1;
    }

    file_t *file = &fs.files[fs.num_files++];
    strcpy(file->name, name);
    file->size = size;

    return 0;
}

int write_file(char *name, char *data, int size) {
    for (int i = 0; i < fs.num_files; i++) {
        file_t *file = &fs.files[i];
        if (strcmp(file->name, name) == 0) {
            if (size > file->size) {
                return -1;
            }

            memcpy(file->data, data, size);
            return 0;
        }
    }

    return -1;
}

int read_file(char *name, char *data, int size) {
    for (int i = 0; i < fs.num_files; i++) {
        file_t *file = &fs.files[i];
        if (strcmp(file->name, name) == 0) {
            if (size > file->size) {
                return -1;
            }

            memcpy(data, file->data, size);
            return 0;
        }
    }

    return -1;
}

int delete_file(char *name) {
    for (int i = 0; i < fs.num_files; i++) {
        file_t *file = &fs.files[i];
        if (strcmp(file->name, name) == 0) {
            for (int j = i; j < fs.num_files - 1; j++) {
                fs.files[j] = fs.files[j + 1];
            }

            fs.num_files--;
            return 0;
        }
    }

    return -1;
}

int main() {
    init_filesystem();

    create_file("file1", 10);
    write_file("file1", "Hello, world!", 13);

    char data[100];
    read_file("file1", data, 100);

    printf("%s\n", data);

    delete_file("file1");

    return 0;
}