//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: puzzling
#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#define MAX_ITEMS 100
#define MAX_NAME 50
#define MAX_PRICE 10
#define MAX_QUANTITY 10

typedef struct {
    char name[MAX_NAME];
    float price;
    int quantity;
} Item;

void addItem(Item items[], int numItems, char name[], float price, int quantity) {
    if (numItems == MAX_ITEMS) {
        printf("Inventory full. Cannot add item.\n");
        return;
    }

    strcpy(items[numItems].name, name);
    items[numItems].price = price;
    items[numItems].quantity = quantity;

    numItems++;
}

void removeItem(Item items[], int numItems, char name[]) {
    int i;

    for (i = 0; i < numItems; i++) {
        if (strcmp(items[i].name, name) == 0) {
            numItems--;
            break;
        }
    }
}

void printInventory(Item items[], int numItems) {
    int i;

    for (i = 0; i < numItems; i++) {
        printf("Name: %s\nPrice: $%.2f\nQuantity: %d\n", items[i].name, items[i].price, items[i].quantity);
    }
}

int main() {
    Item inventory[MAX_ITEMS];
    int numItems = 0;

    addItem(inventory, numItems, "Widget A", 5.99, 10);
    addItem(inventory, numItems, "Widget B", 3.99, 20);
    addItem(inventory, numItems, "Widget C", 7.99, 5);

    printInventory(inventory, numItems);

    removeItem(inventory, numItems, "Widget A");

    printInventory(inventory, numItems);

    return 0;
}