//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 10

typedef struct Item {
  char name[20];
  int quantity;
  float price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name, int quantity, float price) {
  for (int i = 0; i < MAX_ITEMS; i++) {
    if (items[i].name[0] == '\0') {
      strcpy(items[i].name, name);
      items[i].quantity = quantity;
      items[i].price = price;
      return;
    }
  }

  printf("Error: Item limit reached.\n");
}

void displayItems() {
  for (int i = 0; i < MAX_ITEMS; i++) {
    if (items[i].name[0] != '\0') {
      printf("%s - %d, $%.2f\n", items[i].name, items[i].quantity, items[i].price);
    }
  }
}

int calculateTotal() {
  int totalQuantity = 0;
  float totalPrice = 0.0f;

  for (int i = 0; i < MAX_ITEMS; i++) {
    if (items[i].name[0] != '\0') {
      totalQuantity += items[i].quantity;
      totalPrice += items[i].quantity * items[i].price;
    }
  }

  return totalQuantity;
}

int main() {
  addItem("Coffee", 10, 2.50);
  addItem("Tea", 5, 2.20);
  addItem("Juice", 7, 1.80);

  displayItems();

  int totalQuantity = calculateTotal();
  printf("Total Quantity: %d\n", totalQuantity);

  float totalPrice = calculateTotal() * items[0].price;
  printf("Total Price: $%.2f\n", totalPrice);

  return 0;
}