//Falcon-180B DATASET v1.0 Category: CPU usage monitor ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <errno.h>
#include <unistd.h>

#define INTERVAL 5

void usage(char *prog) {
    fprintf(stderr, "Usage: %s [-h]\n", prog);
    exit(1);
}

int main(int argc, char *argv[]) {
    int opt;
    int interval = INTERVAL;

    while ((opt = getopt(argc, argv, "h"))!= -1) {
        switch (opt) {
            case 'h':
                usage(argv[0]);
                break;
            default:
                usage(argv[0]);
        }
    }

    if (getuid()!= 0) {
        fprintf(stderr, "This program must be run as root.\n");
        exit(1);
    }

    struct rusage usage;

    while (1) {
        if (getrusage(RUSAGE_SELF, &usage) == -1) {
            perror("getrusage");
            exit(1);
        }

        float cpu_usage = (float)usage.ru_utime.tv_sec + (float)usage.ru_utime.tv_usec / 1000000;
        float elapsed_time = (float)interval / 1000000;

        printf("CPU usage: %.2f%%\n", cpu_usage / elapsed_time * 100);

        sleep(interval);
    }

    return 0;
}