//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: happy
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of lights
#define MAX_LIGHTS 10

// Define the structure for a light
typedef struct {
    char name[50];
    int brightness;
} Light;

// Initialize the lights
Light lights[MAX_LIGHTS] = {{"Living Room", 0}, {"Kitchen", 0}, {"Bedroom", 0}, {"Bathroom", 0}, {"Hallway", 0}, {"Dining Room", 0}, {"Office", 0}, {"Guest Room", 0}, {"Basement", 0}, {"Garage", 0}};

// Function to set the brightness of a light
void setBrightness(Light* light, int brightness) {
    light->brightness = brightness;
}

// Function to get the brightness of a light
int getBrightness(Light* light) {
    return light->brightness;
}

// Function to turn on all the lights
void turnOnLights() {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        setBrightness(&lights[i], 100);
    }
}

// Function to turn off all the lights
void turnOffLights() {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        setBrightness(&lights[i], 0);
    }
}

// Function to set the brightness of a specific light
void setLightBrightness(char* lightName, int brightness) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, lightName) == 0) {
            setBrightness(&lights[i], brightness);
            printf("The %s light has been set to %d%% brightness.\n", lightName, brightness);
            return;
        }
    }
    printf("The %s light was not found.\n", lightName);
}

// Function to get the brightness of a specific light
int getLightBrightness(char* lightName) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, lightName) == 0) {
            return getBrightness(&lights[i]);
        }
    }
    printf("The %s light was not found.\n", lightName);
    return -1;
}

// Main function
int main() {
    turnOnLights();
    setLightBrightness("Living Room", 50);
    setLightBrightness("Kitchen", 75);
    int livingRoomBrightness = getLightBrightness("Living Room");
    int kitchenBrightness = getLightBrightness("Kitchen");
    printf("The Living Room light is %d%% bright and the Kitchen light is %d%% bright.\n", livingRoomBrightness, kitchenBrightness);
    turnOffLights();
    return 0;
}